/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.rewrite;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.Lazy;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.shared.TinkerCommons;

public class TastyModifierRewrite
extends Modifier
implements GeneralInteractionModifierHook,
OnAttackedModifierHook,
ProcessLootModifierHook {
    private static final Lazy<ItemStack> BACON_STACK = Lazy.of(() -> new ItemStack((ItemLike)TinkerCommons.bacon));

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.GENERAL_INTERACT, ModifierHooks.ON_ATTACKED, ModifierHooks.PROCESS_LOOT);
    }

    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && !tool.isBroken() && player.m_36391_(false)) {
            GeneralInteractionModifierHook.startUsing((IToolStackView)tool, (ModifierId)modifier.getId(), (LivingEntity)player, (InteractionHand)hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private void eat(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        Player player;
        int level = modifier.intEffectiveLevel();
        if (level > 0 && entity instanceof Player && (player = (Player)entity).m_36391_(false)) {
            Level world = entity.m_9236_();
            player.m_36324_().m_38707_(level * 3, 0.6666667f);
            ModifierUtil.foodConsumer.onConsume(player, (ItemStack)BACON_STACK.get(), level, 4.0f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.4f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            if (ToolDamageUtil.directDamage((IToolStackView)tool, (int)(10 * level), (LivingEntity)player, (ItemStack)player.m_21211_())) {
                player.m_21190_(player.m_7655_());
            }
        }
    }

    public void onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        if (!tool.isBroken()) {
            this.eat(tool, modifier, entity);
        }
    }

    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.EAT;
    }

    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 16;
    }

    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        float level = modifier.getEffectiveLevel();
        if (slotType.m_20743_() == EquipmentSlot.Type.HAND) {
            level *= 2.0f;
        }
        if (RANDOM.nextFloat() < level * 0.15f) {
            this.eat(tool, modifier, context.getEntity());
        }
    }

    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81457_)) {
            return;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity != null && entity.m_6095_().m_204039_(TinkerTags.EntityTypes.BACON_PRODUCER)) {
            int looting = context.getLootingModifier();
            if (RANDOM.nextInt(48 / modifier.intEffectiveLevel()) <= looting) {
                generatedLoot.add(new ItemStack((ItemLike)TinkerCommons.bacon));
            }
        }
    }
}

